/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

public final class MIMETypes
extends writer2latex.api.MIMETypes {
    public static final String WRITER = "application/vnd.sun.xml.writer";
    public static final String CALC = "application/vnd.sun.xml.calc";
    public static final String IMPRESS = "application/vnd.sun.xml.impress";
    public static final String DRAW = "application/vnd.sun.xml.draw";
    public static final String CHART = "application/vnd.sun.xml.chart";
    public static final String MATH = "application/vnd.sun.xml.math";
    public static final String ODT = "application/vnd.oasis.opendocument.text";
    public static final String ODS = "application/vnd.oasis.opendocument.spreadsheet";
    public static final String ODP = "application/vnd.oasis.opendocument.presentation";
    public static final String ODF = "application/vnd.oasis.opendocument.formula";
    public static final String ZIP = "application/zip";
    public static final byte[] PNG_SIG = new byte[]{-119, 80, 78, 71};
    public static final byte[] JPEG_SIG = new byte[]{-1, -40, -1, -32};
    public static final byte[] JPEG_EXIF_SIG = new byte[]{-1, -40, -1, -31};
    public static final byte[] GIF87_SIG = new byte[]{71, 73, 70, 56, 55, 97};
    public static final byte[] GIF89_SIG = new byte[]{71, 73, 70, 56, 57, 97};
    public static final byte[] TIFF_SIG = new byte[]{73, 73, 42};
    public static final byte[] BMP_SIG = new byte[]{66, 77};
    public static final byte[] EMF_SIG = new byte[]{1, 0, 0, 0};
    public static final byte[] WMF_SIG = new byte[]{-41, -51, -58, -102};
    public static final byte[] WMF30_SIG = new byte[]{1, 0, 9, 0};
    public static final byte[] EPS_SIG = new byte[]{37, 33};
    public static final byte[] SVM_SIG = new byte[]{86, 67, 76, 77, 84, 70};
    public static final byte[] ZIP_SIG = new byte[]{80, 75, 3, 4};
    public static final String LATEX_EXT = ".tex";
    public static final String BIBTEX_EXT = ".bib";
    public static final String XHTML_EXT = ".html";
    public static final String XHTML_MATHML_EXT = ".xhtml";
    public static final String XHTML_MATHML_XSL_EXT = ".xml";
    public static final String PNG_EXT = ".png";
    public static final String JPEG_EXT = ".jpg";
    public static final String GIF_EXT = ".gif";
    public static final String TIFF_EXT = ".tif";
    public static final String BMP_EXT = ".bmp";
    public static final String EMF_EXT = ".emf";
    public static final String WMF_EXT = ".wmf";
    public static final String EPS_EXT = ".eps";
    public static final String SVM_EXT = ".svm";
    public static final String PDF_EXT = ".pdf";

    private static final boolean isType(byte[] blob, byte[] sig) {
        int n = sig.length;
        for (int i = 0; i < n; ++i) {
            if (blob[i] == sig[i]) continue;
            return false;
        }
        return true;
    }

    public static final String getMagicMIMEType(byte[] blob) {
        if (MIMETypes.isType(blob, PNG_SIG)) {
            return "image/png";
        }
        if (MIMETypes.isType(blob, JPEG_SIG)) {
            return "image/jpeg";
        }
        if (MIMETypes.isType(blob, JPEG_EXIF_SIG)) {
            return "image/jpeg";
        }
        if (MIMETypes.isType(blob, GIF87_SIG)) {
            return "image/gif";
        }
        if (MIMETypes.isType(blob, GIF89_SIG)) {
            return "image/gif";
        }
        if (MIMETypes.isType(blob, TIFF_SIG)) {
            return "image/tiff";
        }
        if (MIMETypes.isType(blob, BMP_SIG)) {
            return "image/bmp";
        }
        if (MIMETypes.isType(blob, EMF_SIG)) {
            return "image/x-emf";
        }
        if (MIMETypes.isType(blob, WMF_SIG)) {
            return "image/x-wmf";
        }
        if (MIMETypes.isType(blob, WMF30_SIG)) {
            return "image/x-wmf";
        }
        if (MIMETypes.isType(blob, EPS_SIG)) {
            return "image/x-eps";
        }
        if (MIMETypes.isType(blob, SVM_SIG)) {
            return "application/x-openoffice-gdimetafile;windows_formatname=\"GDIMetaFile\"";
        }
        if (MIMETypes.isType(blob, ZIP_SIG)) {
            return ZIP;
        }
        return "";
    }

    public static final String getFileExtension(String sMIME) {
        if ("image/png".equals(sMIME)) {
            return PNG_EXT;
        }
        if ("image/jpeg".equals(sMIME)) {
            return JPEG_EXT;
        }
        if ("image/gif".equals(sMIME)) {
            return GIF_EXT;
        }
        if ("image/tiff".equals(sMIME)) {
            return TIFF_EXT;
        }
        if ("image/bmp".equals(sMIME)) {
            return BMP_EXT;
        }
        if ("image/x-emf".equals(sMIME)) {
            return EMF_EXT;
        }
        if ("image/x-wmf".equals(sMIME)) {
            return WMF_EXT;
        }
        if ("image/x-eps".equals(sMIME)) {
            return EPS_EXT;
        }
        if ("application/x-openoffice-gdimetafile;windows_formatname=\"GDIMetaFile\"".equals(sMIME)) {
            return SVM_EXT;
        }
        if ("application/pdf".equals(sMIME)) {
            return PDF_EXT;
        }
        if ("application/x-latex".equals(sMIME)) {
            return LATEX_EXT;
        }
        if ("application/x-bibtex".equals(sMIME)) {
            return BIBTEX_EXT;
        }
        if ("text/html".equals(sMIME)) {
            return XHTML_EXT;
        }
        if ("application/xhtml+xml".equals(sMIME)) {
            return XHTML_MATHML_EXT;
        }
        if ("application/xml".equals(sMIME)) {
            return XHTML_MATHML_XSL_EXT;
        }
        return "";
    }

    public static boolean isVectorFormat(String sMIME) {
        return "image/x-emf".equals(sMIME) || "image/x-wmf".equals(sMIME) || "image/x-eps".equals(sMIME) || "application/x-openoffice-gdimetafile;windows_formatname=\"GDIMetaFile\"".equals(sMIME) || "application/pdf".equals(sMIME);
    }
}

