/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.util;

import java.util.Enumeration;
import java.util.Hashtable;
import writer2latex.latex.util.StyleMapItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleMap {
    private Hashtable<String, StyleMapItem> items = new Hashtable();

    public void put(String sName, String sBefore, String sAfter, String sNext, boolean bLineBreak, int nBreakAfter, boolean bVerbatim) {
        StyleMapItem item = new StyleMapItem();
        item.sBefore = sBefore;
        item.sAfter = sAfter;
        item.sNext = ";" + sNext + ";";
        item.bLineBreak = bLineBreak;
        item.nBreakAfter = nBreakAfter;
        item.bVerbatim = bVerbatim;
        this.items.put(sName, item);
    }

    public void put(String sName, String sBefore, String sAfter, boolean bLineBreak, int nBreakAfter, boolean bVerbatim) {
        StyleMapItem item = new StyleMapItem();
        item.sBefore = sBefore;
        item.sAfter = sAfter;
        item.sNext = ";;";
        item.bLineBreak = bLineBreak;
        item.nBreakAfter = nBreakAfter;
        item.bVerbatim = bVerbatim;
        this.items.put(sName, item);
    }

    public void put(String sName, String sBefore, String sAfter, String sNext, boolean bVerbatim) {
        StyleMapItem item = new StyleMapItem();
        item.sBefore = sBefore;
        item.sAfter = sAfter;
        item.sNext = ";" + sNext + ";";
        item.bLineBreak = true;
        item.nBreakAfter = 2;
        item.bVerbatim = bVerbatim;
        this.items.put(sName, item);
    }

    public void put(String sName, String sBefore, String sAfter) {
        StyleMapItem item = new StyleMapItem();
        item.sBefore = sBefore;
        item.sAfter = sAfter;
        item.sNext = ";;";
        item.bLineBreak = true;
        item.nBreakAfter = 2;
        item.bVerbatim = false;
        this.items.put(sName, item);
    }

    public boolean contains(String sName) {
        return sName != null && this.items.containsKey(sName);
    }

    public String getBefore(String sName) {
        return this.items.get((Object)sName).sBefore;
    }

    public String getAfter(String sName) {
        return this.items.get((Object)sName).sAfter;
    }

    public String getNext(String sName) {
        String sNext = this.items.get((Object)sName).sNext;
        return sNext.substring(1, sNext.length() - 1);
    }

    public boolean isNext(String sName, String sNext) {
        String sNext1 = this.items.get((Object)sName).sNext;
        return sNext1.indexOf(";" + sNext + ";") > -1;
    }

    public boolean getLineBreak(String sName) {
        return this.contains(sName) && this.items.get((Object)sName).bLineBreak;
    }

    public int getBreakAfter(String sName) {
        return this.contains(sName) ? this.items.get((Object)sName).nBreakAfter : 2;
    }

    public boolean getVerbatim(String sName) {
        return this.contains(sName) && this.items.get((Object)sName).bVerbatim;
    }

    public Enumeration<String> getNames() {
        return this.items.keys();
    }
}

