/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXConfig;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.ListStyleConverter;
import writer2latex.latex.util.Context;
import writer2latex.latex.util.HeadingMap;
import writer2latex.office.ListStyle;
import writer2latex.office.OfficeReader;
import writer2latex.util.CSVList;
import writer2latex.util.ExportNameCollection;
import writer2latex.util.Misc;
import writer2latex.util.SimpleInputBuffer;

public class FieldConverter
extends ConverterHelper {
    private static final String ZOTERO_ITEM = "ZOTERO_ITEM";
    private static final String JABREF_ITEM = "JR_cite";
    private ExportNameCollection targets = new ExportNameCollection(true);
    private ExportNameCollection refnames = new ExportNameCollection(true);
    private ExportNameCollection bookmarknames = new ExportNameCollection(true);
    private ExportNameCollection seqnames = new ExportNameCollection(true);
    private ExportNameCollection seqrefnames = new ExportNameCollection(true);
    private Hashtable<String, Node> seqDecl = new Hashtable();
    private Hashtable<String, Element> seqFirst = new Hashtable();
    private Vector<Element> postponedReferenceMarks = new Vector();
    private Vector<Element> postponedBookmarks = new Vector();
    private boolean bUseHyperref = false;
    private boolean bUsesPageCount = false;
    private boolean bUsesTitleref = false;
    private boolean bUsesOooref = false;
    private boolean bConvertZotero = false;
    private boolean bConvertJabRef = false;
    private boolean bIncludeOriginalCitations = false;
    private boolean bUseNatbib = false;

    public FieldConverter(OfficeReader ofr, LaTeXConfig config, ConverterPalette palette) {
        super(ofr, config, palette);
        this.bUseHyperref = config.useHyperref() && !config.useTitleref() && !config.useOooref();
        this.bConvertZotero = config.useBibtex() && config.zoteroBibtexFiles().length() > 0;
        this.bConvertJabRef = config.useBibtex() && config.jabrefBibtexFiles().length() > 0;
        this.bIncludeOriginalCitations = config.includeOriginalCitations();
        this.bUseNatbib = config.useBibtex() && config.useNatbib();
    }

    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        if (this.bUsesPageCount) {
            pack.append("\\usepackage{lastpage}").nl();
        }
        if (this.bUsesTitleref) {
            pack.append("\\usepackage{titleref}").nl();
        }
        if (this.bUsesOooref) {
            pack.append("\\usepackage[");
            HeadingMap hm = this.config.getHeadingMap();
            CSVList opt = new CSVList(",");
            for (int i = 0; i <= hm.getMaxLevel(); ++i) {
                opt.addValue(hm.getName(i));
            }
            pack.append(opt.toString()).append("]{oooref}").nl();
        }
        if (this.bUseHyperref) {
            pack.append("\\usepackage{hyperref}").nl();
            pack.append("\\hypersetup{");
            if (this.config.getBackend() == 2) {
                pack.append("pdftex, ");
            } else if (this.config.getBackend() == 1) {
                pack.append("dvips, ");
            }
            pack.append("colorlinks=true, linkcolor=blue, citecolor=blue, filecolor=blue, urlcolor=blue");
            if (this.config.getBackend() == 2) {
                pack.append(this.createPdfMeta("pdftitle", this.palette.getMetaData().getTitle()));
                if (this.config.metadata()) {
                    pack.append(this.createPdfMeta("pdfauthor", this.palette.getMetaData().getCreator())).append(this.createPdfMeta("pdfsubject", this.palette.getMetaData().getSubject())).append(this.createPdfMeta("pdfkeywords", this.palette.getMetaData().getKeywords()));
                }
            }
            pack.append("}").nl();
        }
        Enumeration<String> names = this.seqFirst.keys();
        while (names.hasMoreElements()) {
            String sName = names.nextElement();
            Element first = this.seqFirst.get(sName);
            String sNumFormat = Misc.getAttribute(first, "style:num-format");
            if (sNumFormat == null) {
                sNumFormat = "1";
            }
            int nLevel = 0;
            String sSepChar = ".";
            if (this.seqDecl.containsKey(sName)) {
                Element sdecl = (Element)this.seqDecl.get(sName);
                nLevel = Misc.getPosInteger(sdecl.getAttribute("text:display-outline-level"), 0);
                if (sdecl.hasAttribute("text:separation-character")) {
                    sSepChar = this.palette.getI18n().convert(sdecl.getAttribute("text:separation-character"), false, this.palette.getMainContext().getLang());
                }
            }
            decl.append("\\newcounter{").append(this.seqnames.getExportName(sName)).append("}");
            String sPrefix = "";
            if (nLevel > 0) {
                int nUsedLevel;
                HeadingMap hm = this.config.getHeadingMap();
                int n = nUsedLevel = nLevel <= hm.getMaxLevel() ? nLevel : hm.getMaxLevel();
                if (nUsedLevel > 0) {
                    decl.append("[").append(hm.getName(nUsedLevel)).append("]");
                    sPrefix = "\\the" + hm.getName(nUsedLevel) + sSepChar;
                }
            }
            decl.nl().append("\\renewcommand\\the").append(this.seqnames.getExportName(sName)).append("{").append(sPrefix).append(ListStyleConverter.numFormat(sNumFormat)).append("{").append(this.seqnames.getExportName(sName)).append("}}").nl();
        }
    }

    public void handleSequenceDecls(Element node) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!Misc.isElement(child, "text:sequence-decl")) continue;
            this.seqDecl.put(((Element)child).getAttribute("text:name"), child);
        }
    }

    public void handleSequence(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String sName = Misc.getAttribute(node, "text:name");
        String sRefName = Misc.getAttribute(node, "text:ref-name");
        String sFormula = Misc.getAttribute(node, "text:formula");
        if (sFormula == null) {
            sFormula = "ooow:" + Misc.getPCDATA(node);
        }
        if (sName != null) {
            if (this.ofr.isFigureSequenceName(sName) || this.ofr.isTableSequenceName(sName)) {
                if (sRefName != null && this.ofr.hasSequenceRefTo(sRefName)) {
                    ldp.append("\\label{seq:").append(this.seqrefnames.getExportName(sRefName)).append("}");
                }
            } else {
                if (!this.seqFirst.containsKey(sName)) {
                    this.seqFirst.put(sName, node);
                }
                if (sRefName != null && this.ofr.hasSequenceRefTo(sRefName)) {
                    ldp.append("{").append(this.changeCounter(sName, sFormula, true)).append("\\the").append(this.seqnames.getExportName(sName)).append("\\label{seq:").append(this.seqrefnames.getExportName(sRefName)).append("}}");
                } else {
                    ldp.append(this.changeCounter(sName, sFormula, false)).append("{\\the").append(this.seqnames.getExportName(sName)).append("}");
                }
            }
        }
    }

    public void handleSequenceLabel(Element node, LaTeXDocumentPortion ldp) {
        String sRefName = Misc.getAttribute(node, "text:ref-name");
        if (sRefName != null && this.ofr.hasSequenceRefTo(sRefName)) {
            ldp.append("\\label{seq:").append(this.seqrefnames.getExportName(sRefName)).append("}");
        }
    }

    private String changeCounter(String sName, String sFormula, boolean bRef) {
        if (sFormula != null && (sFormula = sFormula.trim()).startsWith("ooow:")) {
            SimpleInputBuffer input = new SimpleInputBuffer(sFormula.substring(5));
            if (input.peekChar() >= '0' && input.peekChar() <= '9') {
                String sNumber = input.getInteger();
                if (input.atEnd()) {
                    return this.setCounter(sName, Misc.getPosInteger(sNumber, 0), bRef);
                }
            } else if (input.peekChar() == '-') {
                input.getChar();
                if (input.peekChar() >= '0' && input.peekChar() <= '9') {
                    String sNumber = input.getInteger();
                    if (input.atEnd()) {
                        return this.setCounter(sName, -Misc.getPosInteger(sNumber, 0), bRef);
                    }
                }
            } else {
                String sToken = input.getIdentifier();
                if (sToken.equals(sName)) {
                    input.skipSpaces();
                    if (input.peekChar() == '+') {
                        input.getChar();
                        input.skipSpaces();
                        String sNumber = input.getInteger();
                        if (input.atEnd()) {
                            return this.addtoCounter(sName, Misc.getPosInteger(sNumber, 0), bRef);
                        }
                    } else if (input.peekChar() == '-') {
                        input.getChar();
                        input.skipSpaces();
                        String sNumber = input.getInteger();
                        if (input.atEnd()) {
                            return this.addtoCounter(sName, -Misc.getPosInteger(sNumber, 0), bRef);
                        }
                    } else if (input.atEnd()) {
                        return this.addtoCounter(sName, 0, bRef);
                    }
                }
            }
        }
        return this.stepCounter(sName, bRef);
    }

    private String stepCounter(String sName, boolean bRef) {
        if (bRef) {
            return "\\refstepcounter{" + this.seqnames.getExportName(sName) + "}";
        }
        return "\\stepcounter{" + this.seqnames.getExportName(sName) + "}";
    }

    private String addtoCounter(String sName, int nValue, boolean bRef) {
        if (nValue == 1) {
            return this.stepCounter(sName, bRef);
        }
        if (bRef) {
            return "\\addtocounter{" + this.seqnames.getExportName(sName) + "}" + "{" + Integer.toString(nValue - 1) + "}" + "\\refstepcounter{" + this.seqnames.getExportName(sName) + "}";
        }
        if (nValue != 0) {
            return "\\addtocounter{" + this.seqnames.getExportName(sName) + "}" + "{" + Integer.toString(nValue) + "}";
        }
        return "";
    }

    private String setCounter(String sName, int nValue, boolean bRef) {
        if (bRef) {
            return "\\setcounter{" + this.seqnames.getExportName(sName) + "}" + "{" + Integer.toString(nValue - 1) + "}" + "\\refstepcounter{" + this.seqnames.getExportName(sName) + "}";
        }
        return "\\setcounter{" + this.seqnames.getExportName(sName) + "}" + "{" + Integer.toString(nValue) + "}";
    }

    public void handleSequenceRef(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String sRefName = Misc.getAttribute(node, "text:ref-name");
        String sFormat = Misc.getAttribute(node, "text:reference-format");
        String sName = this.ofr.getSequenceFromRef(sRefName);
        if (sRefName != null) {
            if (sFormat == null || "page".equals(sFormat)) {
                ldp.append("\\pageref{seq:").append(this.seqrefnames.getExportName(sRefName)).append("}");
            } else if ("value".equals(sFormat)) {
                ldp.append("\\ref{seq:").append(this.seqrefnames.getExportName(sRefName)).append("}");
            } else if ("category-and-value".equals(sFormat)) {
                if (sName != null) {
                    if (this.ofr.isFigureSequenceName(sName)) {
                        ldp.append("\\figurename~");
                    } else if (this.ofr.isTableSequenceName(sName)) {
                        ldp.append("\\tablename~");
                    } else {
                        ldp.append(sName).append("~");
                    }
                }
                ldp.append("\\ref{seq:").append(this.seqrefnames.getExportName(sRefName)).append("}");
            } else if ("chapter".equals(sFormat) && this.config.useOooref()) {
                ldp.append("\\chapterref{seq:").append(this.seqrefnames.getExportName(sRefName)).append("}");
                this.bUsesOooref = true;
            } else if ("caption".equals(sFormat) && this.config.useTitleref() && (this.ofr.isFigureSequenceName(sName) || this.ofr.isTableSequenceName(sName))) {
                ldp.append("\\titleref{seq:").append(this.seqrefnames.getExportName(sRefName)).append("}");
                this.bUsesTitleref = true;
            } else if ("text".equals(sFormat) && this.config.useTitleref() && (this.ofr.isFigureSequenceName(sName) || this.ofr.isTableSequenceName(sName))) {
                if (this.ofr.isFigureSequenceName(sName)) {
                    ldp.append("\\figurename");
                } else if (this.ofr.isTableSequenceName(sName)) {
                    ldp.append("\\tablename");
                }
                ldp.append("~\\ref{seq:").append(this.seqrefnames.getExportName(sRefName)).append("}:~\\titleref{").append(this.seqrefnames.getExportName(sRefName)).append("}");
                this.bUsesTitleref = true;
            } else {
                this.palette.getInlineCv().traversePCDATA(node, ldp, oc);
            }
        }
    }

    private boolean handleZoteroReferenceName(String sName, LaTeXDocumentPortion ldp, Context oc) {
        if (sName.startsWith(ZOTERO_ITEM)) {
            int nObjectStart = sName.indexOf(123);
            int nObjectEnd = sName.lastIndexOf(125);
            if (nObjectStart > -1 && nObjectEnd > -1 && nObjectStart < nObjectEnd) {
                String sJsonObject = sName.substring(nObjectStart, nObjectEnd + 1);
                JSONObject jo = null;
                try {
                    jo = new JSONObject(sJsonObject);
                }
                catch (JSONException e) {
                    return false;
                }
                JSONArray citationItemsArray = null;
                try {
                    citationItemsArray = jo.getJSONArray("citationItems");
                }
                catch (JSONException e) {
                    // empty catch block
                }
                if (citationItemsArray != null) {
                    int nCitationCount = citationItemsArray.length();
                    if (this.bUseNatbib) {
                        if (nCitationCount > 1) {
                            ldp.append("\\citetext{");
                        }
                        for (int nIndex = 0; nIndex < nCitationCount; ++nIndex) {
                            JSONObject citationItems = null;
                            try {
                                citationItems = citationItemsArray.getJSONObject(nIndex);
                            }
                            catch (JSONException e) {
                                // empty catch block
                            }
                            if (citationItems == null) continue;
                            if (nIndex > 0) {
                                ldp.append("; ");
                            }
                            String sURI = "";
                            boolean bSuppressAuthor = false;
                            String sPrefix = "";
                            String sSuffix = "";
                            String sLocator = "";
                            String sLocatorType = "";
                            try {
                                sURI = citationItems.getJSONArray("uri").getString(0);
                            }
                            catch (JSONException e) {
                                // empty catch block
                            }
                            try {
                                bSuppressAuthor = citationItems.getBoolean("suppressAuthor");
                            }
                            catch (JSONException e) {
                                // empty catch block
                            }
                            try {
                                sPrefix = citationItems.getString("prefix");
                            }
                            catch (JSONException e) {
                                // empty catch block
                            }
                            try {
                                sSuffix = citationItems.getString("suffix");
                            }
                            catch (JSONException e) {
                                // empty catch block
                            }
                            try {
                                sLocator = citationItems.getString("locator");
                            }
                            catch (JSONException e) {
                                // empty catch block
                            }
                            try {
                                sLocatorType = citationItems.getString("locatorType");
                            }
                            catch (JSONException e) {
                                // empty catch block
                            }
                            if (sLocator.length() > 0 && sLocatorType.length() == 0) {
                                sLocatorType = Pattern.compile("[0-9]+[^0-9]+[0-9]+").matcher(sLocator).find() ? "pp." : "p.";
                            }
                            if (nCitationCount > 1) {
                                if (bSuppressAuthor) {
                                    ldp.append("\\citeyear");
                                } else {
                                    ldp.append("\\citet");
                                }
                            } else if (bSuppressAuthor) {
                                ldp.append("\\citeyearpar");
                            } else {
                                ldp.append("\\citep");
                            }
                            if (sPrefix.length() > 0) {
                                ldp.append("[").append(this.palette.getI18n().convert(sPrefix, true, oc.getLang())).append("]");
                            }
                            if (sPrefix.length() > 0 || sSuffix.length() > 0 || sLocatorType.length() > 0 || sLocator.length() > 0) {
                                ldp.append("[").append(this.palette.getI18n().convert(sSuffix, true, oc.getLang())).append(this.palette.getI18n().convert(sLocatorType, true, oc.getLang()));
                                if (sLocatorType.length() > 0 && sLocator.length() > 0) {
                                    ldp.append("~");
                                }
                                ldp.append(this.palette.getI18n().convert(sLocator, true, oc.getLang())).append("]");
                            }
                            ldp.append("{");
                            int nSlash = sURI.lastIndexOf(47);
                            if (nSlash > 0) {
                                ldp.append(sURI.substring(nSlash + 1));
                            } else {
                                ldp.append(sURI);
                            }
                            ldp.append("}");
                        }
                        if (nCitationCount > 1) {
                            ldp.append("}");
                        }
                    } else {
                        ldp.append("\\cite{");
                        for (int nIndex = 0; nIndex < nCitationCount; ++nIndex) {
                            JSONObject citationItems = null;
                            try {
                                citationItems = citationItemsArray.getJSONObject(nIndex);
                            }
                            catch (JSONException e) {
                                // empty catch block
                            }
                            if (citationItems == null) continue;
                            if (nIndex > 0) {
                                ldp.append(",");
                            }
                            String sURI = "";
                            try {
                                sURI = citationItems.getJSONArray("uri").getString(0);
                            }
                            catch (JSONException e) {
                                // empty catch block
                            }
                            int nSlash = sURI.lastIndexOf(47);
                            if (nSlash > 0) {
                                ldp.append(sURI.substring(nSlash + 1));
                                continue;
                            }
                            ldp.append(sURI);
                        }
                        ldp.append("}");
                    }
                    oc.setInZoteroJabRefText(true);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean handleJabRefReferenceName(String sName, LaTeXDocumentPortion ldp, Context oc) {
        if (sName.startsWith(JABREF_ITEM)) {
            String sRemains = sName.substring(JABREF_ITEM.length());
            int nUnderscore = sRemains.indexOf(95);
            if (nUnderscore > -1 && (sRemains = sRemains.substring(nUnderscore + 1)).length() > 2) {
                String sCommand = this.bUseNatbib ? (sRemains.charAt(0) == '1' ? "\\citep" : "\\citet") : "\\cite";
                ldp.append(sCommand).append("{").append(sRemains.substring(2)).append("}");
            }
            oc.setInZoteroJabRefText(true);
            return true;
        }
        return false;
    }

    private String shortenRefname(String s) {
        int nLast;
        if (s.startsWith(ZOTERO_ITEM) && (nLast = s.lastIndexOf(32)) > 0) {
            return s.substring(nLast + 1);
        }
        return s;
    }

    public void handleReferenceMarkEnd(Element node, LaTeXDocumentPortion ldp, Context oc) {
        oc.setInZoteroJabRefText(false);
        if (this.bIncludeOriginalCitations) {
            ldp.append("{}");
        }
    }

    public void handleReferenceMark(Element node, LaTeXDocumentPortion ldp, Context oc) {
        if (!(oc.isInSection() || oc.isInCaption() || oc.isVerbatim())) {
            String sName = node.getAttribute("text:name");
            if (!(sName == null || this.bConvertZotero && this.handleZoteroReferenceName(sName, ldp, oc) || this.bConvertJabRef && this.handleJabRefReferenceName(sName, ldp, oc))) {
                ldp.append("\\label{ref:" + this.refnames.getExportName(this.shortenRefname(sName)) + "}");
            }
        } else {
            this.postponedReferenceMarks.add(node);
        }
    }

    public void handleReferenceRef(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String sFormat = node.getAttribute("text:reference-format");
        String sName = node.getAttribute("text:ref-name");
        if (("page".equals(sFormat) || "".equals(sFormat)) && sName != null) {
            ldp.append("\\pageref{ref:" + this.refnames.getExportName(this.shortenRefname(sName)) + "}");
        } else if ("chapter".equals(sFormat) && this.ofr.referenceMarkInHeading(sName)) {
            ldp.append("\\ref{ref:" + this.refnames.getExportName(this.shortenRefname(sName)) + "}");
        } else {
            this.palette.getInlineCv().traversePCDATA(node, ldp, oc);
        }
    }

    public void handleBookmark(Element node, LaTeXDocumentPortion ldp, Context oc) {
        if (!(oc.isInSection() || oc.isInCaption() || oc.isVerbatim())) {
            String sName = node.getAttribute("text:name");
            if (sName != null) {
                this.addTarget(node, "", ldp);
                if (this.ofr.hasBookmarkRefTo(sName)) {
                    ldp.append("\\label{bkm:" + this.bookmarknames.getExportName(sName) + "}");
                }
            }
        } else {
            this.postponedBookmarks.add(node);
        }
    }

    public void handleBookmarkRef(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String sFormat = node.getAttribute("text:reference-format");
        String sName = node.getAttribute("text:ref-name");
        if (("page".equals(sFormat) || "".equals(sFormat)) && sName != null) {
            ldp.append("\\pageref{bkm:" + this.bookmarknames.getExportName(sName) + "}");
        } else if ("chapter".equals(sFormat) && this.ofr.bookmarkInHeading(sName)) {
            ldp.append("\\ref{bkm:" + this.bookmarknames.getExportName(sName) + "}");
        } else if (("number".equals(sFormat) || "number-no-superior".equals(sFormat) || "number-all-superior".equals(sFormat)) && (this.ofr.bookmarkInHeading(sName) || this.ofr.bookmarkInList(sName))) {
            ListStyle style = null;
            int nLevel = 0;
            String sPrefix = null;
            String sSuffix = null;
            if (this.ofr.bookmarkInHeading(sName)) {
                if (this.config.formatting() >= 3) {
                    style = this.ofr.getOutlineStyle();
                }
                nLevel = this.ofr.getBookmarkHeadingLevel(sName);
            } else {
                if (this.config.formatting() >= 2) {
                    style = this.ofr.getListStyle(this.ofr.getBookmarkListStyle(sName));
                }
                nLevel = this.ofr.getBookmarkListLevel(sName);
            }
            if (style != null) {
                sPrefix = style.getLevelProperty(nLevel, "style:num-prefix");
                sSuffix = style.getLevelProperty(nLevel, "style:num-suffix");
            }
            if (sPrefix != null) {
                ldp.append(this.palette.getI18n().convert(sPrefix, false, oc.getLang()));
            }
            ldp.append("\\ref{bkm:").append(this.bookmarknames.getExportName(sName)).append("}");
            if (sSuffix != null) {
                ldp.append(this.palette.getI18n().convert(sSuffix, false, oc.getLang()));
            }
        } else {
            this.palette.getInlineCv().traversePCDATA(node, ldp, oc);
        }
    }

    public void flushReferenceMarks(LaTeXDocumentPortion ldp, Context oc) {
        if (!(oc.isInSection() || oc.isInCaption() || oc.isVerbatim())) {
            int i;
            int n = this.postponedReferenceMarks.size();
            for (i = 0; i < n; ++i) {
                this.handleReferenceMark(this.postponedReferenceMarks.get(i), ldp, oc);
            }
            this.postponedReferenceMarks.clear();
            n = this.postponedBookmarks.size();
            for (i = 0; i < n; ++i) {
                this.handleBookmark(this.postponedBookmarks.get(i), ldp, oc);
            }
            this.postponedBookmarks.clear();
        }
    }

    public void handleAnchor(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String sHref = node.getAttribute("xlink:href");
        if (sHref != null) {
            if (sHref.startsWith("#")) {
                if (this.bUseHyperref) {
                    ldp.append("\\hyperlink{").append(this.targets.getExportName(Misc.urlDecode(sHref.substring(1)))).append("}{");
                    this.palette.getInlineCv().traverseInlineText(node, ldp, oc);
                    ldp.append("}");
                } else {
                    this.palette.getInlineCv().handleTextSpan(node, ldp, oc);
                }
            } else if (this.bUseHyperref) {
                if (this.ofr.getTextContent(node).trim().equals(sHref)) {
                    ldp.append("\\url{").append(this.escapeHref(sHref, oc.isInFootnote())).append("}");
                } else {
                    ldp.append("\\href{").append(this.escapeHref(sHref, oc.isInFootnote())).append("}{");
                    this.palette.getInlineCv().traverseInlineText(node, ldp, oc);
                    ldp.append("}");
                }
            } else {
                this.palette.getInlineCv().handleTextSpan(node, ldp, oc);
            }
        } else {
            this.palette.getInlineCv().handleTextSpan(node, ldp, oc);
        }
    }

    public void addTarget(Element node, String sSuffix, LaTeXDocumentPortion ldp) {
        String sName = node.getAttribute("text:name");
        if (sName == null) {
            sName = node.getAttribute("table:name");
        }
        if (sName == null || !this.bUseHyperref) {
            return;
        }
        if (!this.ofr.hasLinkTo(sName + sSuffix)) {
            return;
        }
        ldp.append("\\hypertarget{").append(this.targets.getExportName(sName + sSuffix)).append("}{}");
    }

    public void addTarget(String sName, String sSuffix, LaTeXDocumentPortion ldp) {
        if (sName != null && this.bUseHyperref && this.ofr.hasLinkTo(sName + sSuffix)) {
            ldp.append("\\hypertarget{").append(this.targets.getExportName(sName + sSuffix)).append("}{}");
        }
    }

    public void handlePageNumber(Element node, LaTeXDocumentPortion ldp, Context oc) {
        ldp.append("\\thepage{}");
    }

    public void handlePageCount(Element node, LaTeXDocumentPortion ldp, Context oc) {
        if (this.config.useLastpage()) {
            this.bUsesPageCount = true;
            ldp.append("\\pageref{LastPage}");
        } else {
            ldp.append("?");
        }
    }

    private String createPdfMeta(String sName, String sValue) {
        if (sValue == null) {
            return "";
        }
        sValue = sValue.replace(',', ';');
        return ", " + sName + "=" + this.palette.getI18n().convert(sValue, false, this.palette.getMainContext().getLang());
    }

    private String escapeHref(String s, boolean bInFootnote) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            if (bInFootnote && s.charAt(i) == '#') {
                buf.append("\\#");
                continue;
            }
            if (bInFootnote && s.charAt(i) == '%') {
                buf.append("\\%");
                continue;
            }
            if (s.charAt(i) == '\\') {
                buf.append("\\%5C");
                continue;
            }
            if (s.charAt(i) == '{') {
                buf.append("\\%7B");
                continue;
            }
            if (s.charAt(i) == '}') {
                buf.append("\\%7D");
                continue;
            }
            buf.append(s.charAt(i));
        }
        return buf.toString();
    }
}

